<?php
session_start();
require "../config.php";

// Cek role admin
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard Admin - Apotik</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <a class="navbar-brand" href="#">Admin Apotik</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <li class="nav-item">
                    <span class="nav-link text-white">Halo, Admin</span>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-white" href="../logout.php">Logout</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<div class="container py-4">
    <h2 class="mb-4">Dashboard Admin</h2>

    <div class="row gy-4">

        <!-- Kelola Produk -->
        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">Kelola Produk</h5>
                    <p class="card-text">Tambah, edit, atau hapus produk apotik.</p>
                    <a href="produk.php" class="btn btn-primary">Masuk</a>
                </div>
            </div>
        </div>

        <!-- Tambah Produk -->
        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">Tambah Produk</h5>
                    <p class="card-text">Menambahkan produk baru ke dalam database.</p>
                    <a href="tambah.php" class="btn btn-success">Tambah</a>
                </div>
            </div>
        </div>

        <!-- Laporan -->
        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">Laporan</h5>
                    <p class="card-text">Melihat laporan transaksi dan aktivitas apotik.</p>
                    <a href="laporan.php" class="btn btn-warning text-white">Lihat Laporan</a>
                </div>
            </div>
        </div>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>