<?php
include '../config.php';
session_start();

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'admin') {
    header("Location: ../login.php");
    exit;
}

// Filter tanggal
$filter = "";
if (isset($_GET['dari']) && isset($_GET['sampai'])) {
    $dari = $_GET['dari'];
    $sampai = $_GET['sampai'];
    $filter = "WHERE t.tanggal BETWEEN '$dari' AND '$sampai'";
}

// Query transaksi
$sql = "
SELECT t.id, t.tanggal, t.total, u.username 
FROM transaksi t 
JOIN users u ON t.user_id = u.id
$filter
ORDER BY t.tanggal DESC";

$result = $conn->query($sql);

// Hitung total pemasukan
$sql_total = "
SELECT SUM(total) AS pemasukan 
FROM transaksi 
$filter";

$total_result = $conn->query($sql_total)->fetch_assoc();
$total_pemasukan = $total_result['pemasukan'] ?? 0;

?>
<!DOCTYPE html>
<html>
<head>
    <title>Laporan Transaksi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-5">

    <div class="card shadow">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4>Laporan Transaksi</h4>
            <a href="index.php" class="btn btn-secondary btn-sm">Kembali</a>
        </div>

        <div class="card-body">

            <form class="row mb-4" method="GET">
                <div class="col-md-4">
                    <label>Dari Tanggal</label>
                    <input type="date" name="dari" class="form-control" required value="<?= $_GET['dari'] ?? '' ?>">
                </div>
                <div class="col-md-4">
                    <label>Sampai Tanggal</label>
                    <input type="date" name="sampai" class="form-control" required value="<?= $_GET['sampai'] ?? '' ?>">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button class="btn btn-primary w-100">Filter</button>
                </div>
            </form>

            <div class="alert alert-info">
                <strong>Total Pemasukan: </strong> Rp <?= number_format($total_pemasukan, 0, ',', '.') ?>
            </div>

            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Tanggal</th>
                        <th>Kasir</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): ?>
                        <?php while ($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?= $row['id'] ?></td>
                                <td><?= $row['tanggal'] ?></td>
                                <td><?= $row['username'] ?></td>
                                <td>Rp <?= number_format($row['total'], 0, ',', '.') ?></td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center">Tidak ada transaksi ditemukan</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>

        </div>
    </div>

</div>

</body>
</html>